<?php
/*
 * Created on 13.02.2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * 
 * $Id: AbstractDocumentTest.php 262 2007-08-03 14:48:41Z nmarkgraf $
 */
// Call MetaTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
	define("PHPUnit_MAIN_METHOD", "AbstractDocumentTest::main");
}
/**
 * 
 */
require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";
require_once "PHPUnit/TextUI/TestRunner.php";

/**
 * 
 */
require_once 'OpenDocumentPHP/util/AbstractDocument.php';

/**
 * Test class for util/AbstractDocument.
 * 
 * Some methods in the the abstract class are only to prevent wrong using and
 * allways return 'false'. This will be checked in this test. 
 * 
 * @author 		Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright 	Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license 	http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version    	$Revision: 262 $
 * @package    	OpenDocumentPHP
 * @subpackage	test
 * @since 		0.5.1 - 13.02.2007
 */
/**
 * AbstractDocumentTest class
 * 
 * @author 		Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright 	Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license 	http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version    	$Revision: 262 $
 * @package    	OpenDocumentPHP
 * @subpackage	test
 * @since 		0.5.1 - 13.02.2007
 */
class AbstractDocumentTest extends PHPUnit_Framework_TestCase {
	private $doc;
	/**
	 * Runs the test methods of this class.
	 *
	 * @access 		public
	 * @static
	 * @since 		0.5.1 - 13.02.2007
	 */
    public static function main() 
    {
        $result = PHPUnit_TextUI_TestRunner :: run(self::suite());
    }
	
	/**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     * @since       0.5.3 - 02. Aug. 2007
     */
    public static function suite() 
    {
        $suite = new PHPUnit_Framework_TestSuite("util tests");
        $suite->addTestSuite('AbstractDocumentTest');
        return $suite;
    }
	
	/**
	 * Sets up the fixture, for example, open a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access 		protected
	 * @since 		0.5.1 - 13.02.2007
	 */
	protected function setUp() {
		$this->doc = new AbstractDocument();
	}
	/**
	 * Tears down the fixture, for example, close a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access 		protected
	 * @since 		0.5.1 - 13.02.2007
	 */
	protected function tearDown() {
		unset ($this->doc);
	}
	/**
	 * The method of the class is not needed, so it should always return 'false'!
	 * 
	 * @access 		public
	 * @since 		0.5.1 - 13.02.2007
	 */
	function testLoadHTML() {
		$this->assertFalse($this->doc->loadHTML(' '));
	}
	/**
	 * The method of the class is not needed, so it should always return 'false'!
	 * 
	 * @access 		public
	 * @since 		0.5.1 - 13.02.2007
	 */
	function testLoadHTMLFile() {
		$this->assertFalse($this->doc->loadHTMLFile(' '));
	}
	/**
	 * The method of the class is not needed, so it should always return 'false'!
	 * 
	 * @access 		public
	 * @since 		0.5.1 - 13.02.2007
	 */
	function testSaveHTML() {
		$this->assertFalse($this->doc->saveHTML(' '));
	}
	/**
	 * The method of the class is not needed, so it should always return 'false'!
	 * 
	 * @access 		public
	 * @since 		0.5.1 - 13.02.2007
	 */
	function testSaveHTMLFile() {
		$this->assertFalse($this->doc->saveHTMLFile(' '));
	}
}

if (PHPUnit_MAIN_METHOD == "AbstractDocumentTest::main") {
	AbstractDocumentTest::main();
}
?>
